//=============================================================================
// BloodDrop.
//=============================================================================
class BloodDrop extends UT_BloodDrop;

var() bool bDecal;

function PostBeginPlay()
{
local int i;
local vector HitLocation;

	Velocity.z += 50;
	if ( !Level.bDropDetail )
		Texture = MultiSkins[Rand(8)];
	Drawscale = FRand()*0.2+0.1;

	HitLocation = Self.Location;

	Spawn(class'UT_BigBloodHit',,, HitLocation);

		for (i=0; i<(3); i++)
			{
			v = HitLocation;
			v.X += 2 * FRand();
			v.X -= 3 * FRand();
			v.Y += 2 * FRand();
			v.Y -= 3 * FRand();
			v.Z += 2 * FRand();
			v.Z -= 3 * FRand();
			Spawn(class'UT_BigBloodPuff',,, v);
			}

		for (i=0; i<(5); i++)
			{
			v = HitLocation;
			v.X += 10 * FRand();
			v.X -= 15 * FRand();
			v.Y += 10 * FRand();
			v.Y -= 15 * FRand();
			v.Z += 10 * FRand();
			v.Z -= 15 * FRand();
			Spawn(class'UT_BloodHit',,, v);
			}

		for (i=0; i<(10); i++)
			{
			v = HitLocation;
			v.X += 5 * FRand();
			v.X -= 7 * FRand();
			v.Y += 5 * FRand();
			v.Y -= 7 * FRand();
			v.Z += 5 * FRand();
			v.Z -= 7 * FRand();
			Spawn(class'UT_BloodBurst',,, v);

			v = HitLocation;
			v.X += 10 * FRand();
			v.X -= 13 * FRand();
			v.Y += 10 * FRand();
			v.Y -= 13 * FRand();
			v.Z += 10 * FRand();
			v.Z -= 13 * FRand();
			Spawn(class'UT_BloodBurst',,, v);
			}

		for (i=0; i<(80); i++)
			{
			b = Spawn(class'BloodDrop',,, HitLocation);
			b.Velocity = vector( RotRand() ) * ( FRand() * 300 );
			b.DrawScale *= 2 * Frand();
			}

		for (i=0; i<80; i++)
			{
			b = Spawn(class'BloodDrop',,, HitLocation);
			b.Velocity.Z = i * 6;
			b.Velocity.X += (i / 3) * FRand();
			b.Velocity.X -= (i * 1.5 / 3) * FRand();
			b.Velocity.Y += (i / 5) * FRand();
			b.Velocity.Y -= (i * 1.5 / 5) * FRand();
			b.DrawScale += i * 0.00375 * FRand();
			b.bDecal = False;
			}
}

auto state Explode
{

	simulated function Landed( vector HitNormal )
	{
		if ( bDecal )
			Spawn(class'BloodSplat',,,Location,rotator(HitNormal));
		Destroy();
	}

	simulated function HitWall( vector HitNormal, actor Wall )
	{
		if ( bDecal )
			Spawn(class'BloodSplat',,,Location,rotator(HitNormal));
		Destroy();
	}
}

defaultproperties
{
     bDecal=True
     RemoteRole=ROLE_DumbProxy
     LifeSpan=3.000000
}
